<?= $this->extend('layout/guru_layout'); ?>

<?= $this->section('content'); ?>
<link rel="stylesheet" href="<?= base_url('assets/css/rapor_cover.css'); ?>">
<style>
    /* Styling for the iframe container */
    .preview-container {
        border: 1px solid #ddd;
        border-radius: 8px;
        overflow: hidden;
        margin-top: 20px;
    }
    iframe {
        width: 100%;
        height: 800px;
        border: none;
    }
</style>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('error'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('success'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <?php if (!empty($wali_kelas_data)) : ?>
                    <form action="<?= base_url('guru/rapor_cover'); ?>" method="get" class="mb-3">
                        <div class="form-row align-items-end">
                            <div class="col">
                                <label for="tahun_ajaran_id">Tahun Ajaran:</label>
                                <select name="tahun_ajaran_id" id="tahun_ajaran_id" class="form-control" required>
                                    <option value="">Pilih Tahun Ajaran</option>
                                    <?php foreach ($tahun_ajaran_options as $ta) : ?>
                                        <option value="<?= esc($ta['id']); ?>" <?= (isset($selected_tahun_ajaran_id) && $selected_tahun_ajaran_id == $ta['id']) ? 'selected' : ''; ?>>
                                            <?= esc($ta['tahun_ajaran']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col">
                                <label for="siswa_id">Siswa:</label>
                                <select name="siswa_id" id="siswa_id" class="form-control" required>
                                    <option value="">Pilih Siswa</option>
                                    <?php if (isset($siswa_options) && !empty($siswa_options)) : ?>
                                        <?php foreach ($siswa_options as $s) : ?>
                                            <option value="<?= esc($s['id']); ?>" <?= (isset($selected_siswa_id) && $selected_siswa_id == $s['id']) ? 'selected' : ''; ?>>
                                                <?= esc($s['nama_lengkap']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="col-auto">
                                <button type="submit" class="btn btn-primary">Tampilkan Pratinjau</button>
                            </div>
                        </div>
                    </form>

                    <?php if (isset($siswa_data)) : ?>
                        <!-- Bagian ini diganti dengan iframe untuk pratinjau -->
                        <div class="card mt-3">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5 class="card-title mb-0">Pratinjau Cover Rapor</h5>
                                <!-- Form untuk cetak PDF, target="_blank" akan membuka di tab baru -->
                                <form action="<?= base_url('guru/raporcover/cetak/' . $selected_siswa_id . '/' . $selected_tahun_ajaran_id); ?>" method="post" target="_blank">
                                    <?= csrf_field(); ?>
                                    <button type="submit" class="btn btn-success btn-sm">Cetak PDF</button>
                                </form>
                            </div>
                            <div class="card-body p-0 preview-container">
                                <!-- iframe untuk menampilkan preview dari halaman rapor_cover_pdf -->
                                <iframe src="<?= base_url('guru/raporcover/preview/' . $selected_siswa_id . '/' . $selected_tahun_ajaran_id); ?>"></iframe>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-warning mt-3">Silakan pilih tahun ajaran dan siswa untuk menampilkan pratinjau.</div>
                    <?php endif; ?>

                <?php else: ?>
                    <div class="alert alert-danger">Anda tidak ditugaskan sebagai wali kelas. Fitur ini hanya dapat diakses oleh wali kelas.</div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>
